<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty footnote modifier plugin(Smarty脚注プラグイン）
 *
 * Type:     modifier
 * Name:     footnote
 * Purpose:  format strings like hatena notation (customized only footnote)
 * @link http://www.php-labo.net/
 * @author Knight <info at php-labo dot net> (customized by ccc (http://cccabinet.jpn.org/))
 * @param string
 * @param string
 * @return string
 */
function smarty_modifier_footnote($string, $id = '')
{

	$lines = explode('\n', $string);
	$text  = '';
	$flag  = 0;

	foreach ($lines as $line) {
		if ($flag) {
			if ($flag == 2 or $flag == 3) {
				$line = preg_replace('/\(\(/', ')((', $line);
				$line = preg_replace('/\)\)/', '))(', $line);
			}
		} else {
			$text .= "$line\n";
		}
	}

	if (preg_match_all('/[^\)]\(\(([^(\)\))]+)\)\)[^\(]/', $text, $matches)) {
		$notes = array();
		$i     = 0;
		foreach ($matches[1] as $note) {
			$i++;

			$text = preg_replace('/([^\)])\(\([^(\)\))]+\)\)([^\(])/', "$1<a href=\"#id{$id}_note$i\" name=\"id{$id}_text$i\" id=\"id{$id}_text$i\" title=\"" . strip_tags($note) . "\">*$i</a>$2", $text, 1);

			$notes[] = "<a href=\"#id{$id}_text$i\" name=\"id{$id}_note$i\" id=\"id{$id}_note$i\">*$i</a> : $note";
		}
		$text .= '<p>' . implode('<br />', $notes) . '</p>';
	}
	$text = preg_replace('/\)\(\(/', '((', $text);
	$text = preg_replace('/\)\)\(/', '))', $text);

    return $text;
}

?>
