(function() {
	tinymce.PluginManager.requireLangPack('footnote');//プラグイン固有の言語パックを読み込む

	tinymce.create('tinymce.plugins.footnote', {// プラグイン名
		init : function( ed, url) {
			ed.addCommand( 'add_footnote',// コマンド名
				function() {//　コマンドが実行された時のアクション
				var selected_text = ed.selection.getContent();
				var return_text = '';
				//選択文がある場合は"))"の後にカーソルを移動
				if (selected_text) {
					return_text = '((' + selected_text + '))';
					ed.execCommand('mceInsertContent', 0, return_text);
				//選択文がない場合は"(("と"))"の間にカーソルを移動（参考：https://stackoverflow.com/a/33764968）
				} else {
					return_text = '((<span id="_cursor" />))';
					ed.execCommand('mceInsertContent', 0, return_text);
					ed.selection.select(ed.dom.select('#_cursor')[0]); //挿入された要素を選択
					ed.selection.collapse(0); //選択範囲を範囲の終わりに縮小して、カーソルを挿入された要素の後に
					ed.dom.remove('_cursor'); //要素を削除
				}
			});
			ed.addButton('footnote', {// ボタン名
				title : 'footnote.ftTitle',// ボタンのタイトル（マウスオーバー時に表示される）
				cmd : 'add_footnote',// 上で書いたコマンド名
				image : url + '/img/footnote.png',// ボタン画像のパス
			});
		},
		createControl : function(n, cm) {
			return null;
		},
		getInfo : function() {// プラグインに関する情報
			return {
				longname : 'Footnote plugin',
				author : 'ccc',
				authorurl : 'http://cccabinet.jpn.org/',
				infourl : 'http://cccabinet.jpn.org/view/96',
				version : "1.0"
			};
		}
	});
	tinymce.PluginManager.add('footnote', tinymce.plugins.footnote);//プラグインID,プラグイン関数名
})();