tinymce.PluginManager.requireLangPack('footnote');
tinymce.PluginManager.add('footnote', function(ed, url) {
	ed.addButton('footnote', {
		title: 'ftTitle',
		image : url + '/img/footnote.png',
		cmd : 'footnote',
	});
	ed.addCommand('footnote', function() {
		var selected_text = ed.selection.getContent();
		var return_text = '';
		//選択文がある場合は"))"の後にカーソルが来る
		if (selected_text) {
			return_text = '((' + selected_text + '))';
			ed.execCommand('mceInsertContent', 0, return_text);
		//選択文がない場合は"(("と"))"の間にカーソルが来る（参考：https://stackoverflow.com/a/33764968）
		} else {
			return_text = '((<span id="_cursor" />))';
			ed.execCommand('mceInsertContent', 0, return_text);
			ed.selection.select(ed.dom.select('#_cursor')[0]); //挿入された要素を選択
			ed.selection.collapse(0); //選択範囲を範囲の終わりに縮小して、カーソルを挿入された要素の後に
			ed.dom.remove('_cursor'); //要素を削除
		}
	});
	//メタデータ（ヘルププラグインで使用）
	return {
		getMetadata: function () {
			return {
				name: "Footnote",
				url: "http://cccabinet.jpn.org/view/97"
			};
		}
	};
});
