tinymce.PluginManager.requireLangPack('footnote');
tinymce.PluginManager.add('footnote', function(editor, url) {
	editor.addCommand('footnote', function() {
		var selected_text = editor.selection.getContent();
		var return_text = '';
		//選択文がある場合は"))"の後にカーソルが来る
		if (selected_text) {
			return_text = '((' + selected_text + '))';
			editor.execCommand('mceInsertContent', 0, return_text);
		//選択文がない場合は"(("と"))"の間にカーソルが来る（参考：https://stackoverflow.com/a/33764968）
		} else {
			return_text = '((<span id="_cursor" />))';
			editor.execCommand('mceInsertContent', 0, return_text);
			editor.selection.select(editor.dom.select('#_cursor')[0]); //挿入された要素を選択
			editor.selection.collapse(0); //選択範囲を範囲の終わりに縮小して、カーソルを挿入された要素の後に
			editor.dom.remove('_cursor'); //要素を削除
		}
	});
	
	editor.ui.registry.addButton('footnote', {
		icon: 'footnote',
		tooltip: 'ftTitle',
		onAction: (_) => editor.execCommand('footnote')
	});

	editor.ui.registry.addMenuItem('footnote', {
		text: 'ftTitle',
		icon: 'footnote',
		context: 'tools',
		onAction: (_) => editor.execCommand('footnote')
	});

	editor.ui.registry.addIcon('footnote', '<svg width="24" height="24"><use xlink:href="' + url + '/img/footnote.svg#footnote"></use></svg>');
	
	//メタデータ（ヘルププラグインで使用）
	return {
		getMetadata: function () {
			return {
				name: "Footnote",
				url: "http://cccabinet.jpn.org/"
			};
		}
	};
});
