$(function() {
	$.getJSON("http://query.yahooapis.com/v1/public/yql?callback=?", {
		q: "select * from rss where url in ('http://freo.jp/info/news/feed') limit 5", // limitで扱う「件数」を指定できる。
		format: "json"
	}, function (json) {
		var container = document.getElementById('feed');
		var htmlstr = '<table summary="freo 更新ニュース" class="table table-striped" style="margin-bottom:0"><tbody>';
		for(var i in json.query.results.item){
			var entry = json.query.results.item[i];

			var link = entry.link;
			var title = entry.title;
			var description = entry.description;
			var dateString = new Date(entry.date);
			var year = dateString.getFullYear();
			var month = dateString.getMonth() + 1;
			var day = dateString.getDate();

			var delDate = 15; // NEWマークを表示する日数。
			var dateStringNow = (new Date()).getTime();
			var checkDate =(dateStringNow - dateString) / (1000 * 24 * 3600);

			var elementNew = '';

			if(checkDate <= delDate) {
				elementNew = ' <span class="label label-danger"><strong>New</strong></span>'; // NEWマークをつける場合に表示するHTML要素。
			}

			htmlstr += '<tr><td><h4 style="margin-bottom:3px"><a href="' + link + '">' + title + '</a> <small>（' + year + '/' + month + '/' + day + '）' + elementNew + '</small></h4>' + description + '</td></tr>';

		}
		htmlstr += '</tbody></table>';
		container.innerHTML = htmlstr;
	});
});