DROP TABLE IF EXISTS freo_plugin_catalog_deliveries;
CREATE TABLE freo_plugin_catalog_deliveries(
				id                VARCHAR          NOT NULL,
				created           DATETIME         NOT NULL,
				modified          DATETIME         NOT NULL,
				status            VARCHAR          NOT NULL,
				preferred_week    VARCHAR          NOT NULL,
				preferred_time    VARCHAR          NOT NULL,
				sort              INTEGER UNSIGNED NOT NULL,
				name              VARCHAR          NOT NULL,
				short_min         INTEGER UNSIGNED NOT NULL,
				short_max         INTEGER UNSIGNED NOT NULL,
				long_min          INTEGER UNSIGNED NOT NULL,
				long_max          INTEGER UNSIGNED NOT NULL,
				thickness_min     INTEGER UNSIGNED NOT NULL,
				thickness_max     INTEGER UNSIGNED NOT NULL,
				total_min         INTEGER UNSIGNED NOT NULL,
				total_max         INTEGER UNSIGNED NOT NULL,
				weight_min        INTEGER UNSIGNED NOT NULL,
				weight_max        INTEGER UNSIGNED NOT NULL,
				packing_short     INTEGER UNSIGNED NOT NULL,
				packing_long      INTEGER UNSIGNED NOT NULL,
				packing_thickness INTEGER UNSIGNED NOT NULL,
				packing_total     INTEGER UNSIGNED NOT NULL,
				packing_weight    INTEGER UNSIGNED NOT NULL,
				carriage          INTEGER UNSIGNED,
				text              TEXT,
				PRIMARY KEY(id)
			);

INSERT INTO freo_plugin_catalog_deliveries VALUES('ordinary_25','2013-03-23 11:43:12','2021-07-31 22:23:11','publish','no','no','1','普通郵便（～25g）','1','120','1','235','1','10','1','365','1','25','0','0','0','0','0','84',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('ordinary_50','2013-03-23 11:43:12','2021-07-31 22:23:30','publish','no','no','2','普通郵便（～50g）','1','120','1','235','1','10','1','365','25.1','50','0','0','0','0','0','94',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('standard_50','2021-09-20 11:52:27','2021-09-20 12:04:59','publish','no','no','3','普通郵便（規格内～50g）','90','250','140','340','1','30','230','620','1','50','0','0','0','0','0','120',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('standard_100','2021-09-20 11:52:27','2021-09-20 12:04:59','publish','no','no','4','普通郵便（規格内～100g）','90','250','140','340','1','30','230','620','50.1','100','0','0','0','0','0','140',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('standard_150','2021-09-20 11:52:27','2021-09-20 12:04:59','publish','no','no','5','普通郵便（規格内～150g）','90','250','140','340','1','30','230','620','100.1','150','0','0','0','0','0','210',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('standard_250','2021-09-20 11:52:27','2021-09-20 12:04:59','publish','no','no','6','普通郵便（規格内～250g）','90','250','140','340','1','30','230','620','150.1','250','0','0','0','0','0','250',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('nonstandard_50','2021-09-20 12:04:08','2021-09-20 12:04:08','publish','yes','yes','7','普通郵便（規格外～50g）','90','250','140','600','31','600','230','900','1','50','0','0','0','0','0','200',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('nonstandard_100','2021-09-20 12:04:08','2021-09-20 12:04:08','publish','yes','yes','8','普通郵便（規格外～100g）','90','250','140','600','31','600','230','900','50.1','100','0','0','0','0','0','220',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('nonstandard_150','2021-09-20 12:04:08','2021-09-20 12:04:08','publish','yes','yes','9','普通郵便（規格外～150g）','90','250','140','600','31','600','230','900','100.1','150','0','0','0','0','0','300',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('nonstandard_250','2021-09-20 12:04:08','2021-09-20 12:04:08','publish','yes','yes','10','普通郵便（規格外～250g）','90','250','140','600','31','600','230','900','150.1','250','0','0','0','0','0','350',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('yumail_150','2021-07-31 22:44:48','2021-09-20 11:36:39','publish','no','no','11','ゆうメール（～150g）','1','250','1','340','1','30','1','620','1','150','0','0','0','0','0','180','冊子などの印刷物やCD・DVD限定。
郵便受けに配達します。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('yumail_250','2021-07-31 22:44:48','2021-09-20 11:57:18','publish','no','no','12','ゆうメール（～250g）','1','250','1','340','1','30','1','620','150.1','250','0','0','0','0','0','215','冊子などの印刷物やCD・DVD限定。
郵便受けに配達します。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('yumail_500','2021-07-31 22:44:48','2021-09-20 11:57:40','publish','no','no','13','ゆうメール（～500g）','1','250','1','340','1','30','1','620','250.1','500','0','0','0','0','0','310','冊子などの印刷物やCD・DVD限定。
郵便受けに配達します。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('yumail_1000','2021-07-31 22:44:48','2021-09-20 11:58:02','publish','no','no','14','ゆうメール（～1kg）','1','250','1','340','1','30','1','620','500.1','1000','0','0','0','0','0','360','冊子などの印刷物やCD・DVD限定。
郵便受けに配達します。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('clickpost','2013-03-23 11:43:12','2021-08-01 00:29:45','private','no','no','15','クリックポスト','90','250','140','340','1','30','1','620','1','1000','0','0','0','0','0','198','郵便受けに配達します。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('yupacket_10','2013-03-23 11:43:12','2021-08-01 00:28:09','publish','no','no','16','ゆうパケット（厚さ～1cm）','1','300','1','340','1','10','1','600','1','1000','0','0','0','0','0','250','郵便受けに配達します。
日曜・休日も含めて毎日配達可能。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('yupacket_20','2013-03-23 11:43:12','2021-09-20 11:55:41','publish','no','no','17','ゆうパケット（厚さ～2cm）','1','300','1','340','11','20','1','600','1','1000','0','0','0','0','0','310','郵便受けに配達します。
日曜・休日も含めて毎日配達可能。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('yupacket_30','2013-03-23 11:43:12','2021-09-20 11:56:07','publish','no','no','18','ゆうパケット（厚さ～3cm）','1','300','1','340','21','30','1','600','1','1000','0','0','0','0','0','360','郵便受けに配達します。
日曜・休日も含めて毎日配達可能。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('letterpack_light','2013-03-23 11:43:12','2021-08-01 00:36:13','publish','no','no','19','レターパックライト','1','248','1','340','1','30','1','618','1','4000','0','0','0','0','0','370','郵便受けに配達します。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('letterpack_plus','2013-03-23 11:43:12','2021-07-31 22:26:38','publish','no','no','20','レターパックプラス','1','248','1','340','1','50','1','638','1','4000','0','0','0','0','0','520','対面でお届けし、受領印または署名が必要です。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('smartletter','2013-03-23 11:43:12','2021-07-31 22:26:38','private','no','no','21','スマートレター','1','170','1','250','1','20','1','440','1','1000','0','0','0','0','0','180','A5サイズまでの商品発送用。
郵便受けに配達します。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('yupack_60','2013-03-23 11:43:12','2021-09-20 11:19:35','publish','yes','yes','22','ゆうパック（60サイズ）','1','600','1','600','1','600','1','600','1','25000','0','0','0','0','0',NULL,NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('yupack_80','2013-03-23 11:43:12','2021-09-20 11:58:26','publish','yes','yes','23','ゆうパック（80サイズ）','1','800','1','800','1','800','601','800','1','25000','0','0','0','0','0',NULL,NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('nekoposu','2013-03-23 11:43:12','2021-09-20 11:58:26','private','no','no','24','ネコポス','115','228','230','312','1','250','345','790','1','1000','0','0','0','0','0','385','郵便受けに配達します。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('compact','2013-03-23 11:43:12','2021-09-20 18:21:32','private','yes','yes','25','宅急便コンパクト','1','200','1','250','1','50','1','500','1','99999','7','3','3','0','0','70','送料には専用BOX料金70円（税込み）を含みます。
お届けは手渡しとなります。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('entrust','2013-03-23 11:43:12','2013-03-23 11:43:12','publish','no','no','26','おまかせ','1','9999','1','9999','1','9999','1','9999','1','99999','0','0','0','0','0',NULL,'注文完了後、
配送方法を判断してお知らせします。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('download','2013-03-23 11:43:12','2013-03-23 11:43:12','publish','no','no','27','ダウンロード','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','ダウンロード販売の商品のみを購入される場合、
この配送方法を選択してください。');
INSERT INTO freo_plugin_catalog_deliveries VALUES('mail_10','2013-03-23 11:43:12','2021-07-31 22:52:17','private','no','no','28','メール便（～10mm）','1','400','1','400','1','10','1','700','1','1000','0','0','0','0','0','82',NULL);
INSERT INTO freo_plugin_catalog_deliveries VALUES('mail_20','2013-03-23 11:43:12','2021-07-31 22:52:43','private','no','no','29','メール便（～20mm）','1','400','1','400','10','20','1','700','1','1000','0','0','0','0','0','164',NULL);
DROP TABLE IF EXISTS freo_plugin_catalog_payments;
CREATE TABLE freo_plugin_catalog_payments(
				id         VARCHAR          NOT NULL,
				created    DATETIME         NOT NULL,
				modified   DATETIME         NOT NULL,
				status     VARCHAR          NOT NULL,
				sort       INTEGER UNSIGNED NOT NULL,
				name       VARCHAR          NOT NULL,
				text       TEXT             NOT NULL,
				charge     INTEGER UNSIGNED,
				PRIMARY KEY(id)
			);

INSERT INTO freo_plugin_catalog_payments VALUES('bank','2013-03-23 11:43:12','2013-03-23 11:43:12','publish','1','銀行振込','銀行振込の口座をお知らせします。
振り込み手数料が必要な場合、注文者様の負担となります。
振込名義がご注文者の名前と異なる場合、連絡事項欄で振込名義をお知らせください。',NULL);
INSERT INTO freo_plugin_catalog_payments VALUES('delivery','2013-03-23 11:43:12','2021-09-20 18:20:15','publish','2','代金引換','日本郵便の代金引換サービスです。
商品のお届け時、配送業者が代金を回収します。
配送料や代引手数料を含む合計金額を、配送業者に現金でお支払いください。','265');
INSERT INTO freo_plugin_catalog_payments VALUES('collect','2021-09-20 18:18:02','2021-09-20 18:20:36','private','3','宅急便コレクト','ヤマト運輸の代金引換サービスです。
商品のお届け時、配送業者が代金を回収します。
配送料や代引手数料を含む合計金額を、配送業者に現金でお支払いください。','330');

DROP TABLE IF EXISTS freo_plugin_catalog_delivery_sets;
CREATE TABLE freo_plugin_catalog_delivery_sets(
				delivery_id VARCHAR NOT NULL,
				payment_id  VARCHAR NOT NULL
			);

INSERT INTO freo_plugin_catalog_delivery_sets VALUES('ordinary_25','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('ordinary_50','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('standard_50','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('standard_100','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('standard_150','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('standard_250','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('nonstandard_50','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('nonstandard_100','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('nonstandard_150','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('nonstandard_250','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yupacket_10','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yupacket_20','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yupacket_30','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('clickpost','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yumail_150','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yumail_250','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yumail_500','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yumail_1000','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('letterpack_light','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('letterpack_plus','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('smartletter','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yupack_60','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yupack_60','delivery');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yupack_80','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('yupack_80','delivery');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('nekoposu','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('compact','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('compact','collect');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('entrust','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('entrust','delivery');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('download','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('mail_10','bank');
INSERT INTO freo_plugin_catalog_delivery_sets VALUES('mail_20','bank');


DROP TABLE IF EXISTS freo_plugin_catalog_delivery_prefectures;
CREATE TABLE freo_plugin_catalog_delivery_prefectures(
				delivery_id VARCHAR          NOT NULL,
				prefecture  VARCHAR          NOT NULL,
				carriage    INTEGER UNSIGNED NOT NULL
			);

INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','hokkaido','1300');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','aomori','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','iwate','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','miyagi','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','akita','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','yamagata','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','fukushima','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','ibaraki','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','tochigi','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','gunma','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','saitama','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','chiba','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','tokyo','810');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','kanagawa','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','niigata','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','toyama','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','ishikawa','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','fukui','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','yamanashi','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','nagano','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','gifu','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','shizuoka','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','aichi','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','mie','870');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','shiga','970');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','kyoto','970');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','osaka','970');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','hyogo','970');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','nara','970');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','wakayama','970');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','tottori','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','shimane','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','okayama','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','hiroshima','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','yamaguchi','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','tokushima','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','kagawa','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','ehime','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','kochi','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','fukuoka','1300');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','saga','1300');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','nagasaki','1300');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','kumamoto','1300');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','oita','1300');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','miyazaki','1300');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','kagoshima','1300');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_60','okinawa','1350');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','hokkaido','1530');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','aomori','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','iwate','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','miyagi','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','akita','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','yamagata','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','fukushima','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','ibaraki','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','tochigi','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','gunma','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','saitama','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','chiba','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','tokyo','1030');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','kanagawa','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','niigata','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','toyama','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','ishikawa','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','fukui','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','yamanashi','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','nagano','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','gifu','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','shizuoka','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','aichi','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','mie','1100');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','shiga','1200');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','kyoto','1200');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','osaka','1200');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','hyogo','1200');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','nara','1200');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','wakayama','1200');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','tottori','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','shimane','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','okayama','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','hiroshima','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','yamaguchi','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','tokushima','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','kagawa','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','ehime','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','kochi','1310');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','fukuoka','1530');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','saga','1530');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','nagasaki','1530');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','kumamoto','1530');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','oita','1530');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','miyazaki','1530');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','kagoshima','1530');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('yupack_80','okinawa','1630');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','hokkaido','830');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','aomori','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','iwate','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','miyagi','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','akita','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','yamagata','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','fukushima','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','ibaraki','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','tochigi','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','gunma','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','saitama','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','chiba','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','tokyo','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','kanagawa','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','niigata','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','toyama','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','ishikawa','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','fukui','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','yamanashi','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','nagano','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','gifu','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','shizuoka','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','aichi','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','mie','610');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','shiga','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','kyoto','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','osaka','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','hyogo','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','nara','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','wakayama','660');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','tottori','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','shimane','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','okayama','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','hiroshima','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','yamaguchi','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','tokushima','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','kagawa','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','ehime','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','kochi','720');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','fukuoka','830');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','saga','830');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','nagasaki','830');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','kumamoto','830');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','oita','830');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','miyazaki','830');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','kagoshima','830');
INSERT INTO freo_plugin_catalog_delivery_prefectures VALUES('compact','okinawa','830');

