/*********************************************************************

 freo | 共通関数 (2012/01/25)

 Copyright(C) 2009-2012 freo.jp

*********************************************************************/

$(document).ready(function() {
	//メディア挿入
	$('a.insert').click(function() {
		parent.$('#text').val(parent.$('#text').val() + '\n' + $(this).attr('title'));
		parent.$('#text').keyup();
		parent.$.fn.colorbox.close();
		
		return false;
	});

	//現在日時設定
	$('#setDatetime').click(function() {
		var now = new Date();

		var year   = now.getFullYear();
		var month  = now.getMonth() + 1;
		var day    = now.getDate();
		var hour   = now.getHours();
		var minute = now.getMinutes();
		var second = now.getSeconds();

		if (month  < 10) { month  = '0' + month;  }
		if (day    < 10) { day    = '0' + day;    }
		if (hour   < 10) { hour   = '0' + hour;   }
		if (minute < 10) { minute = '0' + minute; }
		if (second < 10) { second = '0' + second; }

		$('#datetime_year').val(year);
		$('#datetime_month').val(month);
		$('#datetime_day').val(day);
		$('#datetime_hour').val(hour);
		$('#datetime_minute').val(minute);
		$('#datetime_second').val(second);
	});

	//公開終了
	if ($('#article_close_set').val() == '0') {
		$('#article_close').hide();
	}
	$('#article_close_set').change(function() {
		if ($(this).val() == '1') {
			$('#article_close').show();
		} else {
			$('#article_close').hide();
		}
	});

	//閲覧制限
	if ($('#article_restriction').val() == 'group') {
		$('#article_password').hide();
	} else if ($('#article_restriction').val() == 'password') {
		$('#article_group').hide();
	} else {
		$('#article_group, #article_password').hide();
	}
	$('#article_restriction').change(function() {
		if ($(this).val() == 'group') {
			$('#article_group').show();
			$('#article_password').hide();
		} else if ($(this).val() == 'password') {
			$('#article_group').hide();
			$('#article_password').show();
		} else {
			$('#article_group, #article_password').hide();
		}
	});

	//検証
	if ($('#option_type').val() != 'text') {
		$('#option_validate').hide();
	}
	$('#option_type').change(function() {
		if ($(this).val() == 'text') {
			$('#option_validate').show();
		} else {
			$('#option_validate').hide();
		}
	});

	//承認確認
	$('a[rel=approve]').click(function() {
		return confirm('本当に承認してもよろしいですか？');
	});
	$('form[rel=approve]').submit(function() {
		return confirm('本当に承認してもよろしいですか？');
	});

	//削除確認
	$('a[rel=delete]').click(function() {
		return confirm('本当に削除してもよろしいですか？');
	});
	$('form[rel=delete]').submit(function() {
		return confirm('本当に削除してもよろしいですか？');
	});

	//設定確認
	$('a[rel=config]').click(function() {
		return confirm('本当に設定してもよろしいですか？');
	});
	$('form[rel=config]').submit(function() {
		return confirm('本当に設定してもよろしいですか？');
	});

	//ColorBox
	var extensions = ['gif', 'GIF', 'jpeg', 'JPEG', 'jpg', 'JPG', 'jpe', 'JPE', 'png', 'PNG'];

	var target = '';
	$.each(extensions, function() {
		if (target) {
			target += ',';
		}
		target += 'a[href$=\'.' + this + '\']';
	});
	$(target).colorbox({maxHeight:"90%"});

	$('a.colorbox').colorbox({ width:'90%', height:'90%', iframe:true, });

	//テキストエリア
	$('textarea').autoresize({
		padding: 4
	});

	//画像調整
	$('img').not('table tr td img').removeAttr('width').removeAttr('height');
	$('img').not('table tr td img').css('max-width', '300px');

	//閉じる
	$('a[rel=close]').click(function() {
		parent.$.fn.colorbox.close();

		return false;
	});

	//戻る
	var url = location.href;

	url = url.replace(RegExp('^http://' + location.hostname), '');
	url = url.replace(RegExp('index.php$'), '');

	if (url == freo_path) {
		$('#back').hide();
	} else {
		$('a[rel=back]').click(function() {
			history.back();

			return false;
		});
	}

	//アドレスバー調整
	if (!url.match(/#/)) {
		setTimeout(function() {
			scrollTo(0, 1)
		}, 100);
	}

//簡易エディタ
	// 改行タグを挿入
	$('#wrap-enter').click(function(){
		$('#text')
			.selection('insert', {text: '<br />\n', mode: 'before'})
	});
	// 段落タグで囲む
	$('#wrap-paragraph').click(function(){
		$('#text')
			.selection('insert', {text: '<p>', mode: 'before'})
			.selection('insert', {text: '</p>', caret: 'end', mode: 'after'});
	});
	// 続きを読むを挿入
	$('#wrap-pagebreak').click(function(){
		$('#text')
			.selection('insert', {text: '<p><!-- pagebreak --></p>\n', mode: 'before'});
	});
	// 太字タグで囲む
	$('#wrap-strong').click(function(){
		$('#text')
			.selection('insert', {text: '<strong>', mode: 'before'})
			.selection('insert', {text: '</strong>', caret: 'end', mode: 'after'});
	});
	// 下線で囲む
	$('#wrap-under').click(function(){
		$('#text')
			.selection('insert', {text: '<span style="text-decoration: underline;">', mode: 'before'})
			.selection('insert', {text: '</span>', caret: 'end', mode: 'after'});
	});
	// 消し線で囲む
	$('#wrap-stroke').click(function(){
		$('#text')
			.selection('insert', {text: '<span style="text-decoration: line-through;">', mode: 'before'})
			.selection('insert', {text: '</span>', caret: 'end', mode: 'after'});
	});
	// 順序なしリストで囲む
	$('#wrap-ul').click(function(){
		$('#text')
			.selection('insert', {text: '<ul>\n<li>', mode: 'before'})
			.selection('insert', {text: '</li>\n</ul>', mode: 'after'});
	});
	// 順序有りリストで囲む
	$('#wrap-ol').click(function(){
		$('#text')
			.selection('insert', {text: '<ol>\n<li>', mode: 'before'})
			.selection('insert', {text: '</li>\n</ol>', mode: 'after'});
	});
	// リスト項目で囲む
	$('#wrap-li').click(function(){
		$('#text')
			.selection('insert', {text: '<li>', mode: 'before'})
			.selection('insert', {text: '</li>', caret: 'end', mode: 'after'});
	});
	// 見出し4で囲む
	$('#wrap-h4').click(function(){
		$('#text')
			.selection('insert', {text: '<h4>', mode: 'before'})
			.selection('insert', {text: '</h4>', caret: 'end', mode: 'after'});
	});
	// 見出し5で囲む
	$('#wrap-h5').click(function(){
		$('#text')
			.selection('insert', {text: '<h5>', mode: 'before'})
			.selection('insert', {text: '</h5>', caret: 'end', mode: 'after'});
	});
	// 見出し6で囲む
	$('#wrap-h6').click(function(){
		$('#text')
			.selection('insert', {text: '<h6>', mode: 'before'})
			.selection('insert', {text: '</h6>', caret: 'end', mode: 'after'});
	});
	 
	// リンクタグで囲む
	$('#wrap-link').click(function(){
		var selText = $('#text').selection();
		$('#text')
			.selection('insert', {text: '<a href="', mode: 'before'})
			.selection('replace', {text: 'http://', caret: 'end'})
			.selection('insert', {text: '">'+ selText + '</a>', mode: 'after'});
	});
	// イメージタグで囲む
	$('#wrap-img').click(function(){
		var selText = $('#text').selection();
		$('#text')
			.selection('insert', {text: '<img src="', mode: 'before'})
			.selection('replace', {text: 'http://', caret: 'end'})
			.selection('insert', {text: '" alt="'+ selText + '" />', mode: 'after'});
	});
	//Undo・Redo機能
	var strUndo = [];
	var strRedo = [];

	$('#text').on('keydown', function(){
		strUndo.push(jQuery(this).val());
	});
	$('#undo').on('click', function(){
		var temp = strUndo.pop();
		strRedo.push(jQuery('#text').val());
		$('#text').val(temp);
	});
	$('#redo').on('click', function(){
		if(strRedo.length !=0){
			var temp = strRedo.pop();
			strUndo.push(jQuery('#text').val());
			$('#text').val(temp);
		};
	});
	// リアルタイムプレビュー
	$('#form').keyup(function() {
		$('#preview').html($('#text').val());
	});
	// プレビューの表示、非表示切り替え
	$("#preview").css("display", "none");
	//左へスワイプするとプレビュー表示
	$("#form").on("swipeleft", function(){
		$("#text").blur();
		$("#preview").show();
	});
	//右へスワイプするとプレビュー非表示
	$("#form").on("swiperight", function(){
		$("#preview").hide();
		$("#text").focus();
	});

});

//インラインフレームのスクロール（Android対策）
$('#iframe').flickSimple({
	vertical: true,
	horizontal: false,
	lock: true
});

//jQuery MobileのAjax遷移を無効化
$(document).on("mobileinit", function(){
	$.mobile.ajaxEnabled = false;
	$.mobile.hashListeningEnabled = false;
	$.mobile.pushStateEnabled = false;
});

window.onunload = function() {
};
