// ----------------------------------------------------------------------------
// markItUp!
// ----------------------------------------------------------------------------
// Copyright (C) 2008 Jay Salvat
// http://markitup.jaysalvat.com/
// ----------------------------------------------------------------------------
// Html tags
// http://en.wikipedia.org/wiki/html
// ----------------------------------------------------------------------------
// Feel free to add more tags
// ----------------------------------------------------------------------------
mySettings = {
	onShiftEnter: {keepDefault:false, replaceWith:'<br />\n' },
	onCtrlEnter: {keepDefault:false, openWith:'\n<p>', closeWith:'</p>\n' },
	onTab: {keepDefault:false, openWith:'	'},
	markupSet: [
		{name:'色指定', 
			className:'colors', 
			openWith:'<span style="color:[![色を指定]!]">', 
			closeWith:'</span>', 
				dropMenu: [
					{name:'黒色',	openWith:'<span style="color:#000000">', 	closeWith:'</span>', className:"col1-1" },
					{name:'灰色',	openWith:'<span style="color:#808080">', 	closeWith:'</span>', className:"col1-2" },
					{name:'銀色', 	openWith:'<span style="color:#C0C0C0">', 	closeWith:'</span>', className:"col1-3" },
					
					{name:'青色', 	openWith:'<span style="color:#0000FF">', 	closeWith:'</span>', className:"col2-1" },
					{name:'紺色', openWith:'<span style="color:#000080">', 	closeWith:'</span>', className:"col2-2" },
					{name:'水色', 	openWith:'<span style="color:#00FFFF">', 	closeWith:'</span>', className:"col2-3" },
					
					{name:'青緑', 	openWith:'<span style="color:#008080">', 	closeWith:'</span>', className:"col3-1" },
					{name:'緑色', 	openWith:'<span style="color:#008000">', 	closeWith:'</span>', className:"col3-2" },
					{name:'黄緑', 	openWith:'<span style="color:#00FF00">', 	closeWith:'</span>', className:"col3-3" },

					{name:'赤色',	openWith:'<span style="color:#FF0000">', 	closeWith:'</span>', className:"col4-1" },
					{name:'ピンク', 	openWith:'<span style="color:#FF00FF">', 	closeWith:'</span>', className:"col4-2" },
					{name:'黄色', 	openWith:'<span style="color:#FFFF00">', 	closeWith:'</span>', className:"col4-3" },

					{name:'オリーブ',	openWith:'<span style="color:#808000">', 	closeWith:'</span>', className:"col5-1" },
					{name:'紫色', 	openWith:'<span style="color:#800080">', 	closeWith:'</span>', className:"col5-2" },
					{name:'茶色', 	openWith:'<span style="color:#800000">', 	closeWith:'</span>', className:"col5-3" },

					{name:'橙色',	openWith:'<span style="color:#FFA500">', 	closeWith:'</span>', className:"col6-1" },
					{name:'白色', 	openWith:'<span style="color:#FFFFFF">', 	closeWith:'</span>', className:"col6-2" },
					{name:'文字色',	openWith:'<span style="color:#222222">', 	closeWith:'</span>', className:"col6-3" },
				]
		},
		{name:'太字', className:'bold', key:'B', openWith:'(!(<strong>|!|<b>)!)', closeWith:'(!(</strong>|!|</b>)!)' },
		{name:'打消', className:'stroke', key:'S', openWith:'<del>', closeWith:'</del>' },
		{separator:'---------------' },
		{name:'箇条書き', className:'list-bullet', openWith:'<ul>\n<li>', closeWith:'</li>\n</ul>\n' },
		{name:'番号付き箇条書き', className:'list-numeric', openWith:'<ol>\n<li>', closeWith:'</li>\n</ol>\n' },
		{name:'リスト', className:'list-item', openWith:'<li>', closeWith:'</li>' },
		{separator:'---------------' },
		{name:'見出し4', className:'h4', key:'4', openWith:'<h4(!( class="[![クラス名]!]")!)>', closeWith:'</h4>\n', placeHolder:'タイトルをここに...' },
		{name:'見出し5', className:'h5', key:'5', openWith:'<h5(!( class="[![クラス名]!]")!)>', closeWith:'</h5>\n', placeHolder:'タイトルをここに...' },
		{name:'見出し6', className:'h6', key:'6', openWith:'<h6(!( class="[![クラス名]!]")!)>', closeWith:'</h6>\n', placeHolder:'タイトルをここに...' },
		{name:'段落', className:'paragraph', openWith:'<p(!( class="[![クラス名]!]")!)>', closeWith:'</p>\n' },
		{separator:'---------------' },
		{name:'リンク', className:'link', key:'L', openWith:'<a href="[![リンク:!:http://]!]"(!( title="[![Title]!]")!) target="_blank">', closeWith:'</a>', placeHolder:'リンクするテキスト...' },
		{name:'画像', className:'picture', key:'P', replaceWith:'<img src="[![ソース:!:http://]!]" alt="[![代替テキスト]!]" />' },
		{name:'続きを読む', className:'pagebreak', replaceWith:'<!-- pagebreak -->\n' },
		{name:'ネタバレ', className:'netabare', openWith:'<p>', closeWith:'</p>', multiline:true, openBlockWith:'<div class="hidearea"(!( title="[![ボタンのタイトル]!]")!)>\n', closeBlockWith:'\n</div>\n', placeHolder:'ここにネタバレ文...'},
		{name:'コードスタイル', className:'page_code', dropMenu: [
			{name:'コード(code)', className:'code', openWith:'<code(!( class="[![クラス名]!]")!)>', closeWith:'</code>'},
			{name:'整形(pre)', className:'pre', openWith:'<pre(!( class="[![クラス名]!]")!)>', closeWith:'</pre>'},
			{name:'引用(blockquote)', className:'blockquote', openWith:'<blockquote>', closeWith:'</blockquote>\n'},
			{name:'Prism.jsコード', className:'precode', openWith:'<pre class="line-numbers" data-line=""><code class="[![codeクラス名:!:language-]!]">', closeWith:'</code></pre>\n'}
			],
		},
		{separator:'---------------' },
		{name:'HTML実体参照変換',
			className:"htmloff", 
			replaceWith:function(markItUp) { 
				var container = document.createElement('div');
				container.appendChild(document.createTextNode(markItUp.selection));
				return container.innerHTML; 
			}
		},
		{name:'タグ消去', className:'clean', replaceWith:function(markitup) { return markitup.selection.replace(/<(.*?)>/g, "") } },
		{name:'プレビュー', className:'preview', call:'preview' },
		{separator:'---------------' },
		{name:'表作成', 
			className:'tablegenerator', 
			placeholder:"ここにテキスト...",
			replaceWith:function(markItUp) {
				var cols = prompt("何列ですか?"),
					rows = prompt("何行ですか?"),
					html = "<table>\n";
				if (markItUp.altKey) {
					html += " <tr>\n";
					for (var c = 0; c < cols; c++) {
						html += "  <th>[!["+(c+1)+"列目の表題]!]</th>\n";	
					}
					html+= " </tr>\n";
				}
				for (var r = 0; r < rows; r++) {
					html+= " <tr>\n";
					for (var c = 0; c < cols; c++) {
						html += "  <td>"+(markItUp.placeholder||"")+"</td>\n";	
					}
					html+= " </tr>\n";
				}
				html += "</table>\n";
				return html;
			}
		}
	]
}