tinymce.PluginManager.requireLangPack('netabare');
tinymce.PluginManager.add('netabare', function(ed, url) {
	ed.addButton('netabare', {
		image : url + '/img/netabare.png',
		tooltip: 'netabareWindowTitle',
		onclick: function() {
			var selected_text = ed.selection.getContent();
			ed.windowManager.open({
				title: 'netabareWindowTitle',
				body: [
					{type: 'textbox', name: 'title', label: 'netabareButtonTitle'},
					{type: 'label', text: 'netabareButtonTitleText'},
					{type: 'label', text: 'netabareTextTitle'},
					{
						type: 'textbox',
						name: 'text',
						multiline: true,
						minWidth: 300,
						minHeight: 300,
						spellcheck: false,
						style: 'direction: ltr; text-align: left',
						value: selected_text
					},
				],
				onSubmit: function(e) {
					if (e.data.title == '') {
						ed.insertContent('<div class="hidearea"><p>' + e.data.text + '</p></div><p></p>');
					} else {
						ed.insertContent('<div class="hidearea" title="' + e.data.title + '"><p>' + e.data.text + '</p></div><p></p>');
					}
				}
			});
		}
	});
	//メタデータ（ヘルププラグインで使用）
	return {
		getMetadata: function () {
			return {
				name: "Netabare",
				url: "http://cccabinet.jpn.org/view/99"
			};
		}
	};
});
