<?php

/*********************************************************************

 ユーザー登録記事数表示プラグイン (2014/08/16)

 Copyright(C) 2009-2014 freo.jp
 カスタマイズ by cccabinet.org

*********************************************************************/

//外部ファイル読み込み
require_once FREO_MAIN_DIR . 'freo/internals/security_entry.php';
require_once FREO_MAIN_DIR . 'freo/internals/filter_entry.php';

/* メイン処理 */
function freo_display_user_entry_count()
{
	global $freo;

	//検索条件設定
	$condition = null;

	//制限されたエントリーをカウントしない
	if (!$freo->config['view']['restricted_display'] and ($freo->user['authority'] != 'root' and $freo->user['authority'] != 'author')) {
		$entry_filters = freo_filter_entry('user', array_keys($freo->refer['entries']));
		$entry_filters = array_keys($entry_filters, true);
		$entry_filters = array_map('intval', $entry_filters);
		if (!empty($entry_filters)) {
			$condition .= ' AND id NOT IN(' . implode(',', $entry_filters) . ')';
		}

		$entry_securities = freo_security_entry('user', array_keys($freo->refer['entries']), array('password'));
		$entry_securities = array_keys($entry_securities, true);
		$entry_securities = array_map('intval', $entry_securities);
		if (!empty($entry_securities)) {
			$condition .= ' AND id NOT IN(' . implode(',', $entry_securities) . ')';
		}
	}

	//ユーザーごとの記事数取得
	$stmt = $freo->pdo->prepare('SELECT user_id, COUNT(*) FROM ' . FREO_DATABASE_PREFIX . 'entries WHERE approved = \'yes\' AND (status = \'publish\' OR (status = \'future\' AND datetime <= :now1)) AND (close IS NULL OR close >= :now2) ' . $condition . ' GROUP BY user_id');
	$stmt->bindValue(':now1', date('Y-m-d H:i:s'));
	$stmt->bindValue(':now2', date('Y-m-d H:i:s'));
	$flag = $stmt->execute();
	if (!$flag) {
		freo_error($stmt->errorInfo());
	}

	$user_entry_counts = array();
	while ($data = $stmt->fetch(PDO::FETCH_NUM)) {
		$user_entry_counts[$data[0]] = $data[1];
	}

	//データ割当
	$freo->smarty->assign(array(
		'plugin_user_entry_counts' => $user_entry_counts
	));

	return;
}

?>
